******************************
* SET OPTIONS; SET LOCATIONS *
******************************
clear all
set trace off
set more off
global external_dir "D:\Dropbox\Michigan\RDC Project\AEJ Data Set\"			/*CHANGE THIS TO THE DIRECTORY THAT HAS THE FILES*/
global internal_dir "\projects\"											/*This is an internal RDC directory*/

capture log close


**************************************************
* Merge together estimates and balance the panel *
**************************************************

*Bring in Inflow Estimates from Census 2000
use "$internal_dir/data/Census 2000/census2000est_flows.dta", clear

*Add estimates from ACS `start' - `end'
local start = 2005
local end = 2015
forval y=`start'(1)`end' {
	merge 1:1 country year using "$internal_dir/data/ACS `y'/acs`y'est_flows.dta"
	drop _merge
	}

tempfile estimates
save `estimates', replace

*Ensure all country-years have an observation
qui tab country
local C = r(r)
levelsof country, l(cts)
qui tab year
local T = r(r)
levelsof year, l(yrs)
clear all
set obs `C'
gen country = .
local i = 1
foreach c in `cts' {
	replace country = `c' in `i'
	local i = `i'+1
	}
tempfile countries
save `countries', replace
clear
set obs `T'
gen year = .
local i = 1
foreach y in `yrs' {
	replace year = `y' in `i'
	local i = `i'+1
	}
sort year
cross using `countries'
count
merge 1:1 country year using `estimates'
drop _merge 

*Change missing values to 0
forval y=`start'(1)`end' {
	local endy = `y'-1
	replace flows`y' = 0 if year<=`endy' & flows`y'==.
	replace sample`y' = 0 if year<=`endy' & sample`y'==.
	}
replace flows2000 = 0 if year<=1999 & flows2000==.


****************************************
* Average out noise from ACS estimates *
****************************************

local vars = ""
local samples = ""
forval y = `start'(1)`end' {
	local vars = "`vars'" + " flows`y'"
	local samples = "`samples'" + " sample`y'"
	}
display "`vars'"
egen flows_ACS = rowmean(`vars')	/*ACS country-by-year inflow estimates*/
egen sample_ACS = rowtotal(`samples')	/*Sample is the sum since all obs used*/
rename flows2000 flows_Census		/*Census country-by-year inflow estimates*/
rename sample2000 sample_Census

*Keep variables for analysis
keep country year flows_Census flows_ACS

save "$internal_dir/data/combined_Census_ACS_flows.dta", replace
